unit UserApp02Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls,
  Common1, Service01, ImgLoadSave01, Scope01, Oscillograph01;

type
  TUserApp02Form = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Button2: TButton;
    Button3: TButton;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button4: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ComboBox2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    //     
    procedure ShowSensors();
  end;

var
  UserApp02Form: TUserApp02Form;


// =========================================================================
// =========================================================================

implementation
{$R *.dfm}

// =========================================================================
// =========================================================================


// =========================================================================
//   
// =========================================================================

const ArrIndMax = 3;  //     

//   
type TDescScope = array[0..ArrIndMax] of record
     Xb, YB  : integer;
     Compact : boolean;
     Title   : string;
     Min     : extended;
     Max     : extended;
end;

//    
const DescScope : TDescScope =
(
  (Xb:175; YB:28;  Compact:True; Title:' 1'; Min:-110; Max:110),
  (Xb:300; YB:72;  Compact:True; Title:' 2'; Min:-110; Max:110),
  (Xb:406; YB:122; Compact:True; Title:' 3'; Min:-110; Max:110),
  (Xb:568; YB:62;  Compact:True; Title:' 4'; Min:-110; Max:110)
);

// =========================================================================
//    
// =========================================================================

//   
var SelectInd : integer;

//   
var ScopeArr : array[0..ArrIndMax] of TScope;

//  - 
var Osc01 : TOscillograph;

//  -  /  
var ImgLoadSave1 : TLoadSaveImage;   //     Image

// =========================================================================
//     
// =========================================================================
// -------------------------------------------------------------------------
//  
procedure TUserApp02Form.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var Ind : integer;
begin
  //  MouseDown
  StaticText3.Caption := ' ' + IntToStr(X);
  StaticText4.Caption := ' ' + IntToStr(Y);
  //  
  if Shift * [ssAlt] = []
  then begin
     for Ind := Low(ScopeArr) to High(ScopeArr)
     do begin
        if not Assigned(ScopeArr[Ind]) then Continue;
        if IsXYInRect(ScopeArr[Ind].SRect, X, Y)
        then begin
           SelectInd := Ind;
           ComboBox2.ItemIndex := SelectInd;
           if Assigned(Osc01)
           then Osc01.Title := DescScope[SelectInd].Title;
        end;
     end;
  end;
  //  
  if (Shift * [ssAlt] <> []) and Assigned(Osc01)
  then begin
      Osc01.Free;
      Osc01 := TOscillograph.Create(UserApp02Form,
                                    Rect(X + Image1.Left,
                                         Y + Image1.Top,
                                         X + Image1.Left + 270,
                                         Y  + Image1.Top + 200));
      Osc01.Title := DescScope[SelectInd].Title;                                   
  end;
end;
// -------------------------------------------------------------------------
//  
procedure TUserApp02Form.ComboBox2Click(Sender: TObject);
var Ind : integer;
begin
   Ind := ComboBox2.ItemIndex;
   if  (Ind >= Low(ScopeArr)) and (Ind <= High(ScopeArr))
   then begin
      SelectInd := Ind;
      if Assigned(Osc01)
      then Osc01.Title := DescScope[SelectInd].Title;
   end;
end;
// -------------------------------------------------------------------------
//    ()
procedure TUserApp02Form.Button2Click(Sender: TObject);
var Ind : integer;
begin
   Ind := ComboBox2.ItemIndex;
   if Assigned(ScopeArr[Ind])
   then begin
       case ComboBox1.ItemIndex of
       //  
       0 : ScopeArr[Ind].Visible := False;
       // 
       1 : ScopeArr[Ind].Visible := True;
       //  
       2 : ScopeArr[Ind].Compact := True;
       //  
       3 : ScopeArr[Ind].Compact := False;
       //  
       4 : ScopeArr[Ind].Transparent := True;
       // 
       5 : ScopeArr[Ind].Transparent := False;
       end;
   end;
end;
// -------------------------------------------------------------------------
//     
procedure TUserApp02Form.ShowSensors();
var Ind : integer;
begin
   for Ind := Low(ScopeArr) to High(ScopeArr)
   do begin
      if Assigned(ScopeArr[Ind])
      then begin
        ScopeArr[Ind].Value := REC2.Arr[Ind];
        ScopeArr[Ind].DrawScope();
      end;
   end;
   
   if Assigned(Osc01)
   then begin
     Osc01.AddNewData(REC2.Arr[SelectInd]);
     Osc01.ShowBeam;
   end;
end;
// -------------------------------------------------------------------------
//  
procedure TUserApp02Form.Button3Click(Sender: TObject);
const XB = 530;
      YB = 290;
begin
   if not Assigned(Osc01)
   then begin
      Osc01 := TOscillograph.Create(UserApp02Form,
                                    Rect(XB,YB,XB + 270,YB + 200));
      Osc01.Title := ScopeArr[SelectInd].Title;
      Osc01.YMes := ScopeArr[SelectInd].Measure;
   end;
end;
// -------------------------------------------------------------------------
//  
procedure TUserApp02Form.Button4Click(Sender: TObject);
begin
  if Assigned(Osc01)
  then begin
     Osc01.Free;
     Osc01 := nil;
  end;
end;
// =========================================================================
//   /  
// =========================================================================
// -------------------------------------------------------------------------
procedure TUserApp02Form.FormCreate(Sender: TObject);
var Ind : integer;
begin
    // -------------------------------
    //   
    ImgLoadSave1 := TLoadSaveImage.Create(nil,nil);
    ImgLoadSave1.LoadImgFromFile(ApplicationDirectory
                              + '\PICTUREs\engine01.jpg',
                                  Image1);
     // -------------------------------
    ComboBox2.Clear;
    for Ind := Low(ScopeArr) to High(ScopeArr)
    do begin
     ComboBox2.Items.Add(DescScope[Ind].Title);
     ScopeArr[Ind] := TScope.Create(Image1);
     with ScopeArr[Ind]
     do begin
          XBeg := DescScope[Ind].Xb;
          YBeg := DescScope[Ind].Yb;
          Compact := DescScope[Ind].Compact;
          Measure := '.';
          Min := DescScope[Ind].Min;
          Max := DescScope[Ind].Max;
          YZone := 80;
          RZone := 90;
          Title := DescScope[Ind].Title;
          Visible := True;
     end;
     SelectInd := 0;
     ComboBox2.ItemIndex := SelectInd;
   end;
   ComboBox1.ItemIndex := 0;
end;
// -------------------------------------------------------------------------
procedure TUserApp02Form.FormDestroy(Sender: TObject);
var Ind : integer;
begin
   for Ind := Low(ScopeArr) to High(ScopeArr)
    do begin
     if Assigned(ScopeArr[Ind])
     then ScopeArr[Ind].Free;
   end;
   if Assigned(Osc01)
   then begin
     Osc01.Free;
     Osc01 := nil;
  end;
  if Assigned(ImgLoadSave1) then ImgLoadSave1.Free;
end;

// =========================================================================
//  
// =========================================================================

end.
